<!DOCTYPE html>
<html lang="de">
<head>
	<title>Wettbüro für Zuspätkommer/innen</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css" integrity="sha384-TX8t27EcRE3e/ihU7zmQxVncDAy5uIKz4rEkgIXeMed4M0jlfIDPvg6uqKI2xXr2" crossorigin="anonymous"> <!-- von https://getbootstrap.com/docs/4.5/getting-started/introduction/ -->
</head>
<body>
<div class="container">
	<h1>Schülerwettbüro</h1>
	<?php
		$username = 'root';
		$passwort = 'root';
		$server = 'mysql:host=localhost;dbname=wettdatenbank';
		
		try {
			$verbindung = new PDO($server, $username, $passwort);
		} 
		catch(Exception $fehler) {
			print $fehler->getMessage();
		}
		$sqlBefehl = 'select * from wetten';
		$abfrage = $verbindung->prepare($sqlBefehl);
		$abfrage->execute();
		$ergebnismenge = $abfrage->fetchAll();
		
		echo "<table>";
		echo "<thead><tr>";
		echo "<td>Wetter</td><td>Wetter-Mail</td><td>Zuspätkommer</td><td>Minuten</td><td>Grund</td>";	
		echo "</tr></thead>";
		foreach($ergebnismenge as $zeile) {
			echo "<tr>";
			echo "<td>" . $zeile["nameWettender"] . "</td>";
			echo "<td>" . $zeile["emailWettender"] . "</td>";
			echo "<td>" . $zeile["zuspaetkommer"] . "</td>";
			echo "<td>" . $zeile["minuten"] . "</td>";
			echo "<td>" . $zeile["grund"] . "</td>";
			echo "</tr>";
		}
		echo "</table>";	
	?>

	
	
	<form action="index.php" method="post">
		<div>
		  <label for="idNameWettender">Dein Name</label>
		  <input value="Heinz Smith" type="text" id="idNameWettender" name="nameWettender" placeholder="Name eingeben">
		</div>
		<div>
		  <label for="idEmailWettender">Deine Mailadresse?</label>
		  <input value="heinz@smith.co.uk" type="email" id="idEmailWettender" name="emailWettender" placeholder="E-Mail eingeben">
		</div>
		<div>
			<h2>Deine Wette</h2>
			<select id="idZuspaetkommer" name="zuspaetkommer">
				<option value="wladimir">Wladimir</option>
				<option value="alfonsa" selected>Alfonsa</option>
				<option value="martha">Martha</option>
				<option value="guelseren">Gülseren</option>
			</select>
			kommt
			<input value="8" type="number" id="idMinuten" name="minuten" placeholder="Anzahl Minuten">
			<label for "idMinuten"> Minuten</label>
			zu spät
		</div>
		<div>
			<label for "grund">Grund: </label>
			<select id="idGrund" name="grund">
				<option value="stau">Stau</option>
				<option value="wecker">Wecker nicht geklingelt</option>
				<option value="nichtgeweckt">wurde nicht geweckt</option>
				<option value="panne" selected>Fahrradpanne</option>
			</select>
		</div>
		<div>
			<input type="submit" value="Absenden" name="submitknopf" id="idSubmit">
		</div>
	</form> 
</div>

</body>
</html>
